//
//  CuePointHistory.h
//  TritonPlayerSDK
//
//  Copyright (c) 2015 Triton Digital. All rights reserved.
//

#import <Foundation/Foundation.h>

/// Errors generated by TDCuePointHistory
typedef NS_ENUM(NSInteger, TDCuePointHistoryError) {
    
    /// The mount was not specified or is invalid
    TDCuePointHistoryInvalidMountError = 3000,
    
    /// An unknown error occurred
    TDCuePointHistoryUnknownError = 3001
};

extern NSString *const TDCuePointHistoryErrorDomain;

/**
 * TDCuePointHistory retrieves the “Now Playing History” information for a station from Triton Digital’s network.
 */

@interface TDCuePointHistory : NSObject

/**
 * Request now playing history information in an asynchronous fashion.
 *
 * @param mountName An NSString with the mount of the station whose history will be requested.
 * @param maximum An NSInteger containing the maximum number of now playing events to retrieve. If the number is greater than what is available, all available data is returned.
 * @param filter An NSArray of Cue point event types to filter the events returned. If nil is specified, all available types are returned. See CuePointEvent for all the possible values
 * @param completionHandler A block containing an NSArray of CuePointEvent objetcs. Each CuePointEvent represents an entry in the history. In case an error occurs, the historyItems will be nil and the error parameter will be filled instead.
 */

-(void)requestHistoryForMount:(NSString *)mountName
             withMaximumItems:(NSInteger)maximum
              eventTypeFilter:(NSArray*)filter
            completionHandler:(void (^)(NSArray *historyItems,
                                        NSError *error))completionHandler;

@end
